package gov.va.med.mhv.common.api.exception;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public class MHVException extends Exception {
	private static final long serialVersionUID = -4071682123518375837L;
	
	private static final int STACK_TRACE_LIMIT = 5;

	private MHVErrorEnumeration errorCode = MHVErrorEnumeration.ERROR;

	private Map<String, String> errorMessages;
	private Map<String, String> validationErrorMessages;
	private Map<String, String> infoMessages;
	private String failureMessage;
	private String objectString;

	public MHVException() {
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public MHVException( ResponseUtil response) {
		this.setErrorCode((response.getValidationErrors() != null && response.getValidationErrors().size() > 0) ? MHVErrorEnumeration.VALIDATION : MHVErrorEnumeration.ERROR);
		this.setFailureMessage(response.getFailureMessage());
		this.setInfoMessages(response.getInfoMessages());
		this.setValidationErrorMessages(response.getValidationErrors());
	} 
	
	public MHVException(Map<String, String> infoMessages, Map<String, String> validationMessages, String errorMessage) {
		this.setErrorCode((validationMessages != null && validationMessages.size() > 0) ? MHVErrorEnumeration.VALIDATION : MHVErrorEnumeration.ERROR);
		this.setFailureMessage(errorMessage);
		this.setInfoMessages(infoMessages);
		this.setValidationErrorMessages(validationMessages);
	}
	
	public MHVException(Map<String, String> infoMessages, Map<String, String> validationMessages, String errorMessage,String objectString) {
		this.setErrorCode((validationMessages != null && validationMessages.size() > 0) ? MHVErrorEnumeration.VALIDATION : MHVErrorEnumeration.ERROR);
		this.setFailureMessage(errorMessage);
		this.setInfoMessages(infoMessages);
		this.setValidationErrorMessages(validationMessages);
		this.setObjectString(objectString);
	}

	public MHVException(String message) {
		super(message);
		setFailureMessage(message);
	}

	public MHVException(Throwable t) {
		super(t);
		setFailureMessage(t.getMessage());
	}

	public MHVException(String message, Throwable t) {
		super(message, t);
		setFailureMessage(message);
	}

	public MHVException(ErrorEnum err) {
		this.setFailureMessage(String.valueOf(err.getId()) + ":" + err.getErrorMessage());
	}

	public MHVException(ErrorEnum err, Throwable t) {
		this(t);
		this.setFailureMessage(String.valueOf(err.getId()) + ":" + err.getErrorMessage());
	}

	public MHVErrorEnumeration getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(MHVErrorEnumeration errorCode) {
		this.errorCode = errorCode;
	}
	
	@Override
	public StackTraceElement[] getStackTrace() {
		return Arrays.copyOf(super.getStackTrace(), STACK_TRACE_LIMIT);
	}

	public Map<String, String> getErrorMessages() {
		if (null == this.errorMessages) {
			this.errorMessages = new LinkedHashMap<String, String>();
		}
		return errorMessages;
	}

	public void setErrorMessages(Map<String, String> errorMessages) {
		this.errorMessages = errorMessages;
	}

	public Map<String, String> getValidationErrorMessages() {
		if (null == this.validationErrorMessages) {
			this.validationErrorMessages = new LinkedHashMap<String, String>();
		}
		return validationErrorMessages;
	}

	public void setValidationErrorMessages(
			Map<String, String> validationErrorMessages) {
		this.validationErrorMessages = validationErrorMessages;
	}

	public Map<String, String> getInfoMessages() {
		if (null == this.infoMessages) {
			this.infoMessages = new LinkedHashMap<String, String>();
		}
		return infoMessages;
	}

	public void setInfoMessages(Map<String, String> infoMessages) {
		this.infoMessages = infoMessages;
	}

	public String getFailureMessage() {
		return failureMessage;
	}

	public void setFailureMessage(String failureMessage) {
		this.failureMessage = failureMessage;
	}

	public String getObjectString() {
		return objectString;
	}

	public void setObjectString(String objectString) {
		this.objectString = objectString;
	}
	
}
